function _Dataset(archived)
    local dataset
    Profiler.time("unarchive Dataset", function()
        dataset = Dataset:new(unarchive(archived.title))
        dataset:group(function(dataset)
            dataset:setAttribution(unarchive(archived.attribution))
            if type(archived.fields) == 'table' then
                for index = 1, #archived.fields do
                    local field = unarchive(archived.fields[index])
                    dataset:addField(field.name, field.default, field.width)
                end
            end
            if type(archived.entries) == 'table' then
                for index = 1, #archived.entries do
                    local entry = unarchive(archived.entries[index])
                    dataset:add(entry)
                end
            end
        end)
    end)
    return dataset
end

return _Dataset
